#include <bits/stdc++.h>
using namespace std;
using ll = long long;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<ll> x(n), h(n);
    for (int i = 0; i < n; i++) cin >> x[i];
    for (int i = 0; i < n; i++) cin >> h[i];

    vector<int> id(n);
    iota(id.begin(), id.end(), 0);
    sort(id.begin(), id.end(), [&](int a, int b) {
        return x[a] < x[b];
    });

    vector<ll> xs(n), hs(n);
    for (int i = 0; i < n; i++) {
        xs[i] = x[id[i]];
        hs[i] = h[id[i]];
    }

    const ll INF = (ll)4e18;
    vector<ll> ans(n, INF);

   
    multiset<ll> st;
    for (int i = 0; i < n; i++) {
        ll val = hs[i] - xs[i];
        if (!st.empty()) {
            ans[i] = min(ans[i], xs[i] + hs[i] - *st.begin());
        }
        st.insert(val);
    }

 
    st.clear();
    for (int i = n - 1; i >= 0; i--) {
        ll val = hs[i] + xs[i];
        if (!st.empty()) {
            ans[i] = min(ans[i], *st.begin() - (xs[i] - hs[i]));
        }
        st.insert(val);
    }

    vector<ll> res(n, -1);
    for (int i = 0; i < n; i++) {
        if (ans[i] != INF) res[id[i]] = ans[i];
    }

    for (int i = 0; i < n; i++) {
        cout << res[i] << "\n";
    }
}